<?php
session_start();

function random_str($length) {
    return bin2hex(random_bytes($length / 2));
}

$client_id = '9f47d562-03e0-4ce4-812b-8367ce104240';
$redirect_uri = 'https://solucoeszion.com/yampi/redirect.php';

if (!isset($_GET['code'])) {
    // 1. Iniciar o fluxo
    $state = random_str(40);
    $code_verifier = random_str(128);
    $_SESSION['state'] = $state;
    $_SESSION['code_verifier'] = $code_verifier;

    // Gera o code_challenge
    $encoded = base64_encode(hash('sha256', $code_verifier, true));
    $code_challenge = strtr(rtrim($encoded, '='), '+/', '-_');

    $query = http_build_query([
        'client_id' => $client_id,
        'redirect_uri' => $redirect_uri,
        'response_type' => 'code',
        'state' => $state,
        'code_challenge' => $code_challenge,
        'code_challenge_method' => 'S256',
    ]);

    header("Location: https://auth.yampi.com.br/oauth/authorize?$query");
    exit;
}

// 2. Recebe o código de autorização
if ($_GET['state'] !== $_SESSION['state']) {
    exit('Erro: estado inválido.');
}

$code = $_GET['code'];
$code_verifier = $_SESSION['code_verifier'];

// Troca o code por access_token
$data = http_build_query([
    'grant_type' => 'authorization_code',
    'client_id' => $client_id,
    'redirect_uri' => $redirect_uri,
    'code' => $code,
    'code_verifier' => $code_verifier,
]);

$options = [
    'http' => [
        'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
        'method'  => 'POST',
        'content' => $data,
    ],
];

$context = stream_context_create($options);
$result = file_get_contents('https://auth.yampi.com.br/oauth/token', false, $context);

if ($result === false) {
    exit('Erro ao obter token.');
}

$tokenData = json_decode($result, true);

// Salva o token para testes (opcional)
file_put_contents(__DIR__ . '/token-storage.json', json_encode($tokenData, JSON_PRETTY_PRINT));

// Mostra o token
echo "<h2>Token recebido com sucesso!</h2><pre>";
print_r($tokenData);
echo "</pre>";
