<?php
// frete.php

// Define cabeçalho de resposta como JSON
header('Content-Type: application/json');

// Permite apenas requisição POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Método não permitido. Use POST.']);
    exit;
}

// Captura o corpo da requisição
$input = file_get_contents('php://input');

// Tenta decodificar como JSON
$data = json_decode($input, true);

// Verifica se é um JSON válido
if (!is_array($data)) {
    http_response_code(400); // Bad Request
    echo json_encode(['error' => 'Requisição inválida. JSON malformado.']);
    exit;
}

// Salva log da requisição para análise posterior
file_put_contents(__DIR__ . '/log_frete.json', json_encode([
    'headers' => getallheaders(),
    'body' => $data,
    'received_at' => date('Y-m-d H:i:s')
], JSON_PRETTY_PRINT));

// Retorna resposta simulada (temporária)
echo json_encode([
    'data' => [
        [
            'name' => 'PAC Simulado',
            'price' => 19.90,
            'deadline' => 7
        ],
        [
            'name' => 'SEDEX Simulado',
            'price' => 29.90,
            'deadline' => 3
        ]
    ]
]);
