<?php

header('Content-Type: application/json');

// Inicializa array da resposta
$response = [
    'metodo' => $_SERVER['REQUEST_METHOD'],
    'get' => $_GET,
    'post' => $_POST,
    'headers' => [],
    'raw_body' => file_get_contents('php://input'),
    'json_body' => null
];

// Tenta decodificar o corpo como JSON (se for)
$jsonDecoded = json_decode($response['raw_body'], true);
if (is_array($jsonDecoded)) {
    $response['json_body'] = $jsonDecoded;
}

// Captura os headers HTTP
if (function_exists('getallheaders')) {
    $response['headers'] = getallheaders();
} else {
    foreach ($_SERVER as $key => $value) {
        if (strpos($key, 'HTTP_') === 0) {
            $headerName = str_replace('_', '-', substr($key, 5));
            $response['headers'][$headerName] = $value;
        }
    }
}

// Log opcional: salve os dados num arquivo
file_put_contents('log_yampi.json', json_encode($response, JSON_PRETTY_PRINT));

// Mostra os dados recebidos
echo json_encode($response, JSON_PRETTY_PRINT);
