<?php
session_start();

function random_str($length) {
    return bin2hex(random_bytes($length / 2));
}

$client_id = '9f47d562-03e0-4ce4-812b-8367ce104240';
$redirect_uri = 'https://solucoeszion.com/yampi/redirect.php';

if (!isset($_GET['code'])) {
    // 1. Iniciar o fluxo
    $state = random_str(40);
    $code_verifier = random_str(128);
    $_SESSION['state'] = $state;
    $_SESSION['code_verifier'] = $code_verifier;

    // Gera o code_challenge
    $encoded = base64_encode(hash('sha256', $code_verifier, true));
    $code_challenge = strtr(rtrim($encoded, '='), '+/', '-_');

    $query = http_build_query([
        'client_id' => $client_id,
        'redirect_uri' => $redirect_uri,
        'response_type' => 'code',
        'state' => $state,
        'code_challenge' => $code_challenge,
        'code_challenge_method' => 'S256',
    ]);

    header("Location: https://auth.yampi.com.br/oauth/authorize?$query");
    exit;
}

// 2. Valida o estado de retorno
if (!isset($_GET['state'], $_SESSION['state']) || $_GET['state'] !== $_SESSION['state']) {
    exit('Erro: estado inválido.');
}

$code = $_GET['code'];
$code_verifier = $_SESSION['code_verifier'];

// Troca o code por access_token
$data = http_build_query([
    'grant_type' => 'authorization_code',
    'client_id' => $client_id,
    'redirect_uri' => $redirect_uri,
    'code' => $code,
    'code_verifier' => $code_verifier,
]);

$options = [
    'http' => [
        'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
        'method'  => 'POST',
        'content' => $data,
    ],
];

$context = stream_context_create($options);
$result = file_get_contents('https://auth.yampi.com.br/oauth/token', false, $context);

if ($result === false) {
    exit('Erro ao obter token.');
}

$tokenData = json_decode($result, true);

// Validação básica do token recebido
if (!isset($tokenData['access_token'], $tokenData['merchant'])) {
    echo "<h2>Erro ao obter token válido:</h2><pre>";
    print_r($tokenData);
    echo "</pre>";
    exit;
}

// Salva o token para testes
file_put_contents(__DIR__ . '/token-storage.json', json_encode($tokenData, JSON_PRETTY_PRINT));

// Mostra o token na tela
echo "<h2>Token recebido com sucesso!</h2><pre>";
print_r($tokenData);
echo "</pre>";

// Dados principais
$access_token = $tokenData['access_token'];
$merchant_alias = $tokenData['merchant'];

// URL e dados do webhook
$webhook_url = 'https://solucoeszion.com/yampi/webhook-listener.php';
$webhook_data = [
    'url' => $webhook_url,
    'events' => ['order.created'],
    'name' => 'Webhook de integração com CRM'
];

// LOG: grava informações da requisição
file_put_contents(__DIR__ . '/debug-webhook-request.json', json_encode([
    'token' => $access_token,
    'client_id' => $client_id,
    'alias' => $merchant_alias,
    'url' => "https://api.dooki.com.br/v2/$merchant_alias/webhooks",
    'payload' => $webhook_data
], JSON_PRETTY_PRINT));

$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.dooki.com.br/v2/$merchant_alias/webhooks",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_TIMEOUT => 15,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode($webhook_data),
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "Authorization: Bearer $access_token",
        "X-Partner-Client-ID: $client_id"
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

echo "<h2>Resultado da criação do Webhook:</h2><pre>";
if ($err) {
    echo "Erro: $err";
} else {
    $webhookResponse = json_decode($response, true);
    print_r($webhookResponse);

    // Se tiver secret_key, salva para uso posterior
    if (isset($webhookResponse['secret_key'])) {
        file_put_contents(__DIR__ . "/webhook-secret-{$merchant_alias}.json", json_encode([
            'secret_key' => $webhookResponse['secret_key'],
            'webhook_id' => $webhookResponse['id'] ?? null,
            'created_at' => date('Y-m-d H:i:s')
        ], JSON_PRETTY_PRINT));
    }
}
echo "</pre>";

// ==== Criação da API de Frete ====
$freteApiUrl = "https://api.dooki.com.br/v2/$merchant_alias/logistics/apis";

// Dados da API de frete
$frete_api_data = [
    'name' => 'API de Frete Zion',
    'url' => 'https://solucoeszion.com/yampi/frete.php',
    'active' => true,
    'headers' => [
        [
            'key' => 'Authorization',
            'value' => 'Bearer SEU_TOKEN_INTERNO_DO_APP' // pode ser uma chave sua, validada no endpoint
        ]
    ]
];

// Log da requisição
file_put_contents(__DIR__ . '/debug-api-frete-request.json', json_encode([
    'token' => $access_token,
    'client_id' => $client_id,
    'url' => $freteApiUrl,
    'payload' => $frete_api_data
], JSON_PRETTY_PRINT));

// Faz a requisição via cURL
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => $freteApiUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 15,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode($frete_api_data),
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "Authorization: Bearer $access_token",
        "X-Partner-Client-ID: $client_id"
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

echo "<h2>Resultado da criação da API de Frete:</h2><pre>";
if ($err) {
    echo "Erro: $err";
} else {
    $apiFreteResponse = json_decode($response, true);
    print_r($apiFreteResponse);

    // Salva resposta para debug se necessário
    file_put_contents(__DIR__ . "/api-frete-response-{$merchant_alias}.json", json_encode($apiFreteResponse, JSON_PRETTY_PRINT));
}
echo "</pre>";

?>
